/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class OverlayRendererStructures
extends OverlayRendererBase {
    public static final OverlayRendererStructures INSTANCE = new OverlayRendererStructures();
    private List<StructureData> structures = new ArrayList<StructureData>();
    private boolean hasData = false;

    private OverlayRendererStructures() {
    }

    @Override
    public String getName() {
        return "Structures";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)hysteresis || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)hysteresis || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)hysteresis;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        int maxRange = ((Integer)mc.field_1690.method_42503().method_41753() + 4) * 16;
        this.structures = this.getStructuresToRender(this.lastUpdatePos, maxRange);
        this.hasData = !this.structures.isEmpty();
        this.renderThrough = Configs.Generic.STRUCTURES_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.structures.isEmpty();
    }

    @Override
    protected void allocateBuffers(boolean useOutlines) {
        this.clearBuffers();
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Main Quads", MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_1));
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Components", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH));
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderStructureMain(cameraPos, mc, profiler);
        this.renderStructureComponents(cameraPos, mc, profiler);
    }

    private void renderStructureMain(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("structure main");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:structure/main_quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        for (StructureData structure : this.structures) {
            StructureToggle toggle = structure.getStructureType().getToggle();
            Color4f mainColor = toggle.getColorMain().getColor();
            IntBoundingBox bb = structure.getBoundingBox();
            RenderUtils.drawBoxNoOutlines(bb, cameraPos, mainColor, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererStructures#renderStructureMain(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderStructureComponents(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("structure components");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:structure/component_quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        for (StructureData structure : this.structures) {
            StructureToggle toggle = structure.getStructureType().getToggle();
            Color4f componentColor = toggle.getColorComponents().getColor();
            ImmutableList<IntBoundingBox> components = structure.getComponents();
            if (components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.getFirst(), structure.getBoundingBox())) continue;
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBoxNoOutlines(bb, cameraPos, componentColor, builder);
            }
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererStructures#renderStructureComponents(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.structures.clear();
    }

    private List<StructureData> getStructuresToRender(class_2338 playerPos, int maxRange) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureDataWithinRange(playerPos, maxRange);
        ArrayList<StructureData> data = new ArrayList<StructureData>();
        for (StructureType type : structures.keySet()) {
            if (!type.isEnabled()) continue;
            data.addAll(structures.get((Object)type));
        }
        return data;
    }
}

